package tiktak

import (
	"agent/client"
	"agent/commons/debug"
	"agent/commons/utime"
	"context"
	"sync"
)

// Модуль отвечает за авторизацию и постоянный "пинга" сервиса

type tiktakModule struct {
}

func (m *tiktakModule) Init(ctx context.Context) (err error) {
	return nil
}

func (m *tiktakModule) Name() string {
	return "TikTak"
}

func (m *tiktakModule) Commands() []client.ICommand {
	return nil
}

func (m *tiktakModule) Run(ctx context.Context, wg *sync.WaitGroup) {
	defer func() {
		wg.Done()
	}()

	go m.ping(ctx)
	m.login(ctx)
}

func (m *tiktakModule) OnLogin(ctx context.Context, config map[string]any) (err error) {
	return nil
}

func (m *tiktakModule) login(ctx context.Context) {
	cl := client.ExtractClient(ctx)
	for {
		select {
		case <-ctx.Done():
			return
		default:
		}

		utime.Sleep(utime.Second * 1)

		if !cl.IsAuthorized() {
			if !cl.CanLogin() {
				continue
			}
			if err := cl.Login(ctx); err != nil {
				debug.LogErrf("Login: %v", err)
				continue
			}
		}
	}
}

func (m *tiktakModule) ping(ctx context.Context) {
	cl := client.ExtractClient(ctx)
	for {
		select {
		case <-ctx.Done():
			return
		default:
		}

		if !cl.IsAuthorized() {
			utime.Sleep(utime.Second * 1)
			continue
		}

		timeNow := utime.Now()
		interval := cl.Interval()

		if nextPing := cl.LastPing().Add(utime.Second * utime.Duration(interval.Ping)); nextPing.After(timeNow) {
			utime.Sleep(utime.Second * 1)
			continue
		}

		utime.Sleep(utime.Second * 5)

		if !cl.IsAuthorized() {
			continue
		}

		if err := cl.Ping(ctx); err != nil {
			debug.LogErrf("Ping: %v", err)
		}
	}
}
