package merrs

import "agent/defines/derrs"

const (
	CodeFailedConnectTo        derrs.Code = 2000
	CodeFailedSetWriteDeadline derrs.Code = 2001
	CodeFailedSendHandshake    derrs.Code = 2002
	CodeFailedReadResponse     derrs.Code = 2003
	CodeFailedWrite            derrs.Code = 2004
	CodeFailedRead             derrs.Code = 2005
)

var Join = derrs.Join

func NewFailedConnectToError(details ...string) error {
	return derrs.NewError(CodeFailedConnectTo, "failed connect to", details...)
}

func NewFailedSetWriteDeadlineError(details ...string) error {
	return derrs.NewError(CodeFailedSetWriteDeadline, "failed set write deadline", details...)
}

func NewFailedSendHandshakeError(details ...string) error {
	return derrs.NewError(CodeFailedSendHandshake, "failed send handshake", details...)
}

func NewFailedReadResponseError(details ...string) error {
	return derrs.NewError(CodeFailedReadResponse, "failed read response", details...)
}

func NewFailedWriteError(details ...string) error {
	return derrs.NewError(CodeFailedWrite, "failed write", details...)
}

func NewFailedReadError(details ...string) error {
	return derrs.NewError(CodeFailedRead, "failed read", details...)
}
