//go:build !windows

package cmds

import (
	"agent/commons/utils"
	"io/fs"
	"syscall"
	"time"
)

func listFolder(path string, deep int, full bool, expandPath bool) (res [][]string, err error) {
	var paths []string

	if path == "/" || path == "\\" {
		paths = append(paths, "/")
	} else {
		paths = append(paths, path)
	}

	return list2(paths, deep, full, expandPath)
}

func createItem(entry fs.DirEntry, path string, count int, full bool) (res []string) {
	var item []string
	if full {
		item = make([]string, 0, 5)
	} else {
		item = make([]string, 0, 2)
	}

	item = append(item, "0", path)
	if entry.IsDir() {
		item[0] = "1"
	}

	if full {
		if info, err := entry.Info(); err == nil {
			size := info.Size()
			created := int64(0)
			updated := info.ModTime().UTC().UnixNano()

			if stat, ok := info.Sys().(*syscall.Stat_t); ok {
				// Явно приводим к int64, так как на разных архитектурах (32-битных и 64-битных)
				// поля Sec и Nsec могут иметь разные типы (int32 или int64),
				// а функция time.Unix ожидает именно int64.
				sec := int64(stat.Ctim.Sec)
				nsec := int64(stat.Ctim.Nsec)
				created = time.Unix(sec, nsec).UTC().UnixNano()
			}

			item = append(item, utils.Int64ToStrList(int64(count), size, created, updated)...)
		}
	}

	return item
}
