package cmds

import (
	"agent/commons/debug"
	"agent/commons/utils"
	"agent/defines/dcmds"
	"agent/defines/derrs"
	"agent/defines/devent/daction"
	"agent/defines/devent/dcategory"
	"context"
	"path/filepath"
)

type FolderCreateCmd struct {
	dcmds.UserToAgentCmd
}

func (c *FolderCreateCmd) Category() []Category {
	return []Category{dcategory.Agent, dcategory.Rfs, dcategory.Folder}
}

func (c *FolderCreateCmd) Action() Action {
	return daction.Create
}

func (c *FolderCreateCmd) Execute(ctx context.Context, eventIn IEvent) (eventOut IEvent, err error) {
	debug.Log("FolderCreateCmd")

	meta := eventIn.Meta()

	path, ok := meta["path"].(string)
	if !ok {
		return nil, derrs.NewIncorrectParamsError("path not found")
	}
	path = normalizePath(path)

	debug.Logf("FolderCreated: %s\n\n", path)

	if err = utils.DirCreate(path); err != nil {
		return nil, err
	}

	dir := filepath.Dir(path)
	if len(dir) == 0 {
		return nil, nil
	}

	return listFoldersToResultEvent(eventIn, dir)
}
