package console

import (
	"agent/internal/include"
	"agent/modules/console/internal/console"
	"agent/modules/console/internal/workers"
	"context"
	"sync"
)

type consoleModule struct{}

func (m *consoleModule) Init(ctx context.Context) (err error) {
	return nil
}

func (m *consoleModule) Name() string {
	return "Console"
}

func (m *consoleModule) Commands() []include.ICommand {
	return nil
}

func (m *consoleModule) Run(ctx context.Context, wg *sync.WaitGroup) {
	defer func() {
		wg.Done()
	}()

	consoleManager := console.NewConsoleManager()

	go workers.InputWorker(ctx, consoleManager)
	// OutputWorker выполняется в текущей горутине удерживая её
	workers.OutputWorker(ctx, consoleManager)
}

func (m *consoleModule) OnLogin(ctx context.Context, config map[string]any) (err error) {
	return nil
}
