package utils

import (
	"bufio"
	"os"
	"strings"
)

func CurrentShell() string {
	shell := os.Getenv("SHELL")
	if shell == "" {
		shell = os.Getenv("COMSPEC")
	}
	return shell
}

func AvailableShells() (shells []string, err error) {
	file, err := os.Open("/etc/shells")
	if err != nil {
		return []string{}, err
	}
	defer file.Close()
	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		line := strings.TrimSpace(scanner.Text())
		if len(line) > 0 && !strings.HasPrefix(line, "#") {
			shells = append(shells, line)
		}
	}
	if err := scanner.Err(); err != nil {
		return shells, err
	}
	return shells, nil
}
