package include

import (
	"encoding/json"

	"github.com/google/uuid"
)

type CommandItem struct {
	Uuid    uuid.UUID
	Command string
}

func (i CommandItem) MarshalJSON() ([]byte, error) {
	jsonData := map[string]any{
		"uuid":    i.Uuid,
		"command": i.Command,
	}
	return json.Marshal(jsonData)
}

func (i *CommandItem) UnmarshalJSON(data []byte) error {
	jsonData := map[string]any{}
	if err := json.Unmarshal(data, &jsonData); err != nil {
		return err
	}
	if val, ok := jsonData["uuid"].(string); ok {
		parsedUuid, err := uuid.Parse(val)
		if err != nil {
			return err
		}
		i.Uuid = parsedUuid
	}
	if val, ok := jsonData["command"].(string); ok {
		i.Command = val
	}
	return nil
}
