package console

import (
	"agent/commons/debug"
	"sync"

	"github.com/google/uuid"
)

func NewConsole(uuid uuid.UUID, opts ...NewConsoleOpts) *Console {
	var o NewConsoleOpts
	if len(opts) > 0 {
		o = opts[0]
	}
	args := []string{}
	// Просим консоль работать в UTF-8 сразу со старта
	if o.Utf8OnStart {
		args = append(args, "/K", "chcp", "65001")
	}
	if len(o.Args) > 0 {
		args = append(args, o.Args...)
	}

	var consoleInitCommands []CommandItem
	if !o.Utf8OnStart {
		// Устанавливаем кодировку UTF-8 через команду, если не сделали это при старте
		consoleInitCommands = append(consoleInitCommands, CommandItem{Command: "chcp 65001"})
	}

	return &Console{
		uuid:          uuid,
		closeCallback: o.CloseCallback,

		command: "cmd",
		args:    args,
		cwd:     o.Cwd,
		env:     o.Env,
		lock:    &sync.RWMutex{},

		// Каналл вмещает в себя 1024 буфера
		consoleOutput:       make(chan []byte, 1024),
		consoleCommands:     make(chan CommandItem),
		consoleInitCommands: consoleInitCommands,
	}
}

func (c *Console) pipeWriter() {
	for _, cmd := range c.consoleInitCommands {
		if _, err := c.inPipe.Write([]byte(cmd.Command + "\n")); err != nil {
			debug.Log(err)
			return
		}
	}

	for {
		select {
		case <-c.procCtx.Done():
			return
		case command := <-c.consoleCommands:
			if command.Command[0] == 0x04 || command.Command == "^C" {
				// Ctrl+C
				c.inPipe.Write([]byte{0x03})
			} else if command.Command[0] == 0x1a || command.Command == "^Z" {
				// Ctrl+Z
				c.inPipe.Write([]byte{0x1a})
			} else {
				if _, err := c.inPipe.Write([]byte(command.Command + "\n")); err != nil {
					debug.Log(err)
					return
				}
			}
		}
	}
}
