package console

import (
	"agent/commons/debug"
	"agent/modules/console/defines/merrs"
	"syscall"
)

func init() {
	kernel32 := syscall.NewLazyDLL("kernel32.dll")
	user32 := syscall.NewLazyDLL("user32.dll")
	if err := initConsole(kernel32, user32); err != nil {
		debug.Log(err)
	}
}

func initConsole(kernel32 *syscall.LazyDLL, user32 *syscall.LazyDLL) error {
	procAllocConsole := kernel32.NewProc("AllocConsole")
	r1, _, err := procAllocConsole.Call()
	if r1 == 0 {
		return merrs.Join(err, merrs.NewAllocConsoleFailedError(err.Error()))
	}

	procGetConsoleWnd := kernel32.NewProc("GetConsoleWindow")
	procShowWindow := user32.NewProc("ShowWindow")
	hwnd, _, _ := procGetConsoleWnd.Call()
	if hwnd != 0 {
		// Прячем окно
		procShowWindow.Call(hwnd, 0)
	}

	return nil
}
