package merrs

import "agent/defines/derrs"

const (
	CodeConsoleIsntStarted     derrs.Code = 1000
	CodeAllocConsoleFailed     derrs.Code = 1001
	CodeFailedOpenProcess      derrs.Code = 1002
	CodeFailedTreminateProcess derrs.Code = 1003
	CodeFailedListProcess      derrs.Code = 1004
	CodeFailedFindProcess      derrs.Code = 1005
	CodeFailedKillProcess      derrs.Code = 1006
	CodeFailedSignalProcess    derrs.Code = 1007
)

var Join = derrs.Join

func NewConsoleIsntStartedError(details ...string) *derrs.Error {
	return derrs.NewError(CodeConsoleIsntStarted, "console isn't started", details...)
}

func NewAllocConsoleFailedError(details ...string) *derrs.Error {
	return derrs.NewError(CodeAllocConsoleFailed, "alloc console failed", details...)
}

func NewFailedOpenProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedOpenProcess, "can't open process", details...)
}

func NewFailedTreminateProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedTreminateProcess, "failed terminate process", details...)
}

func NewFailedListProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedListProcess, "failed list processes", details...)
}

func NewFailedFindProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedFindProcess, "failed find process", details...)
}

func NewFailedKillProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedKillProcess, "failed kill process", details...)
}

func NewFailedSignalProcessError(details ...string) *derrs.Error {
	return derrs.NewError(CodeFailedSignalProcess, "failed signal process", details...)
}
