//go:build release && !dev

// Release билд запускается без логирования. Конфиг читается из config.Data.
package internal

import (
	"agent/client/config"
	"agent/commons/app"
	"os"
)

func AppMain() {
	config, err := config.Get()
	if err != nil {
		os.Exit(1)
	}
	ctx, err := app.New(config)
	if err != nil {
		os.Exit(1)
	}
	app.Run(ctx)
}
