//go:build debug

// Debug билд запускается с логированием. Конфиг читается из файла.
package internal

import (
	"agent/client/config"
	"agent/commons/app"
	"agent/commons/debug"
	"agent/commons/vars"
	"flag"
)

func AppMain() {
	configFile := flag.String("config", vars.DefaultConfigPath, "path to config.json")
	logFile := flag.String("logfile", "./app.log", "path to app.log file (optional)")
	flag.Parse()

	if len(*logFile) == 0 {
		*logFile = "./app.log"
	}

	initLogger(*logFile)

	config, err := config.Get(*configFile)
	if err != nil {
		debug.Panic(err)
	}

	ctx, err := app.New(config)
	if err != nil {
		debug.Panic(err)
	}
	app.Run(ctx)
}
