//go:build debug || dev

package internal

import (
	"agent/commons/debug"
	"agent/commons/logger"
	"agent/commons/utils"
	"fmt"
	"os"
	"path/filepath"
	"time"
)

func initLogger(logFile string) {
	logFile, err := filepath.Abs(logFile)
	if err != nil {
		fmt.Printf("failed to get absolute path for log file: %v\n", err)
		os.Exit(1)
	}

	var opts []logger.Option

	if utils.FileIsExist(logFile) {
		// При каждом запуске лог-файл очищается. Если запуск происходит не из VSCode, то делаем ротацию лог-файла,
		// чтобы сохранять предыдущие логи.
		if !utils.FileIsExist("./main.go") {
			logDir := filepath.Dir(logFile)
			filename := utils.FileName(logFile)
			ext := filepath.Ext(logFile)
			date := time.Now().Format("2006-01-02_15-04-05")
			utils.FileCopy(fmt.Sprintf("%s/%s_%s%s", logDir, filename, date, ext), logFile)
		}
		// Очищаем лог-файл при каждом запуске
		opts = append(opts, logger.WithOpenFlags(os.O_CREATE|os.O_WRONLY|os.O_TRUNC))
	}

	l, err := logger.New(logFile, opts...)
	if err != nil {
		fmt.Printf("failed to initialize logger: %v\n", err)
		os.Exit(1)
	}

	debug.SetLogger(l)
	debug.Logf(`Using log file: "%s"`, logFile)
}
