package include

import (
	"context"
)

type ITransport interface {
	Init(ctx context.Context)

	Name() string
	Schema() string
	Host() string
	Port() int

	IsAuthorized() bool
	Reset()

	Token() string
	SetToken(token string)
	SetServerTime(ntime int64)

	Execute(ctx context.Context, eventIn IEvent) (eventOut IEvent, err error)
}
