package include

import (
	"context"
	"sync"
)

type IModuleName interface {
	Name() string
}

type IModule interface {
	IModuleName

	Init(ctx context.Context) (err error)
	Commands() []ICommand
	Run(ctx context.Context, wg *sync.WaitGroup)

	OnLogin(ctx context.Context, config map[string]any) (err error)
}
