package include

import (
	"agent/defines/derrs"
	"context"
)

type ICommandSignature interface {
	Kind() EventKind
	Category() []EventCategory
	Action() EventAction
}

type ICommand interface {
	ICommandSignature

	Execute(ctx context.Context, eventIn IEvent) (eventOut IEvent, err error)
}

type BaseCmd struct{}

func (b *BaseCmd) Kind() EventKind {
	panic(derrs.NewNotImplementedError())
}

func (b *BaseCmd) Category() []EventCategory {
	panic(derrs.NewNotImplementedError())
}

func (b *BaseCmd) Action() EventAction {
	panic(derrs.NewNotImplementedError())
}

func (b *BaseCmd) Execute(ctx context.Context, eventIn IEvent) (eventOut IEvent, err error) {
	return nil, derrs.NewNotImplementedError()
}
