package vars

import "agent/commons/utime"

const (
	// FIX_ME: Все значения должны быть настраиваемыми через конфиг
	DefaultLoginInterval = 5
	MaxLoginInterval     = 30
	// Если задано, будет применяться вместо значения полученного от сервиса
	ForceNextEventInterval = 0
	// Интервал по умолчанию, если не задан сервисом
	DefaultNextEventInterval = 15
	// FIX_ME: END

	DefaultAlphabet              = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	DefaultFormDataFileExtension = ".data"

	RequestMinTrashSize = 0
	RequestMaxTrashSize = 1024
	LoginTimeout        = utime.Duration(5000) * utime.Second

	// Тестовый режим для генерации мусора, последовательно увеличивает размер мусора на +1
	TestTrash = false
)

var (
	// Размер маски используемой в операциях маскировки XorKey
	MaskKeySize = 4
)
