package utils

import (
	"encoding/json"
)

func Unused(...any) {
}

func PointerTo[T any](v T) *T {
	return &v
}

func ConvertTo[T any](from any) (res T, err error) {
	b, err := json.Marshal(from)
	if err != nil {
		return res, err
	}
	err = json.Unmarshal(b, &res)
	return res, err
}

func MapValues[M ~map[K]V, K comparable, V any](m M) []V {
	values := make([]V, 0, len(m))
	for _, v := range m {
		values = append(values, v)
	}
	return values
}
