package utils

import (
	"agent/commons/debug"
	"agent/defines/derrs"
	"crypto/rand"
	"math/big"
	"strconv"
)

func RoundTo(val int, to int) int {
	if val == 0 {
		return to
	} else if val%to == 0 {
		return val
	}
	return (val + (to - val%to))
}

// IntN возвращает случайное число в полуинтервале [0, n).
// Паника, если n <= 0.
func IntN(n int) int {
	if n <= 0 {
		debug.Panic(derrs.NewIncorrectParamsError("n must be greater than 0"))
	}

	// Преобразуем n в *big.Int
	max := big.NewInt(int64(n))

	// Генерируем случайное число в диапазоне [0, max)
	rnd, err := rand.Int(rand.Reader, max)
	if err != nil {
		panic(err)
	}

	return int(rnd.Int64())
}

func Int64ToStrList(val ...int64) (res []string) {
	res = make([]string, 0, len(val))
	for _, v := range val {
		res = append(res, strconv.FormatInt(v, 10))
	}
	return res
}
