package response

import (
	"agent/commons/crypto"
	"agent/defines/derrs"
	"io"
)

func SkipPadding(stream io.Reader, cipher crypto.ICipher, requestSize int64) error {
	if cipher == nil {
		return derrs.NewUnknownError("cipher is nil")
	}
	if requestSize == 0 {
		return nil
	}
	// Если используется алгоритм шифрования, с блоком больше 1 байта, могут появляться байты выравнивания. Их
	// необходимо выбросить из потока, иначе следующий запрос будет прочитан некорректно.
	if padding := cipher.EncryptOutputSize(int(requestSize)) - int(requestSize); padding > 0 {
		//log.Printf("Padding: %d\n", padding)
		_, err := io.CopyN(io.Discard, stream, int64(padding))
		return err
	}
	return nil
}
