package logger

import "log"

type Logger struct {
	info *log.Logger
	errx *log.Logger
}

func (l *Logger) Info(v ...any) {
	l.info.Print(v...)
}

func (l *Logger) Infoln(v ...any) {
	l.info.Println(v...)
}

func (l *Logger) Infof(format string, v ...any) {
	l.info.Printf(format, v...)
}

func (l *Logger) Infofln(format string, v ...any) {
	l.info.Printf(format+"\n", v...)
}

func (l *Logger) Error(v ...any) {
	l.errx.Print(v...)
}

func (l *Logger) Errorln(v ...any) {
	l.errx.Println(v...)
}

func (l *Logger) Errorf(format string, v ...any) {
	l.errx.Printf(format, v...)
}

func (l *Logger) Errorfln(format string, v ...any) {
	l.errx.Printf(format+"\n", v...)
}

func (l *Logger) Panic(v any) {
	l.errx.Panic(v)
}

func (l *Logger) Panicf(format string, v ...any) {
	l.errx.Panicf(format, v...)
}
