package debug

import (
	"fmt"
)

func Log(v ...any) {
	if log == nil {
		return
	}

	log.Info(v...)
}

func Logf(format string, v ...any) {
	if log == nil {
		return
	}

	log.Infof(format, v...)
}

func LogErr(v ...any) {
	if log == nil {
		return
	}

	prefix := fmt.Sprintf(`"%s" `, getCaller(1))
	v = append([]any{prefix}, v...)
	log.Error(v...)
}

func LogErrf(format string, v ...any) {
	if log == nil {
		return
	}

	prefix := fmt.Sprintf(`"%s" `, getCaller(1))
	format = prefix + format
	log.Errorf(format, v...)
}
