package cross

import (
	"github.com/google/uuid"
	"golang.org/x/sys/windows/registry"
)

func DeviceUuid() (uuid.UUID, error) {
	key, err := registry.OpenKey(
		registry.LOCAL_MACHINE, `SOFTWARE\Microsoft\Cryptography`, registry.QUERY_VALUE,
	)
	if err != nil {
		return uuid.Nil, err
	}
	defer key.Close()
	deviceUuid, _, err := key.GetStringValue("MachineGuid")
	if err != nil {
		return uuid.Nil, err
	}
	return uuid.MustParse(deviceUuid), nil
}
