//go:build !windows

package cross

import (
	"crypto/md5"

	"github.com/denisbrodbeck/machineid"
	"github.com/google/uuid"
)

// DeviceUuid для разных платформ (Win/Linux/MacOS/FreeBSD).
func DeviceUuid() (uuid.UUID, error) {
	machineID, err := machineid.ID()
	if err != nil {
		return uuid.Nil, err
	}
	machineUuid, err := uuid.Parse(machineID)
	if err != nil {
		machineUuid = uuid.UUID(md5.Sum([]byte(machineID)))
	}
	return machineUuid, nil
}
