package client

import (
	"context"
)

type clientKeyCtx struct{}

func SetClient(ctx context.Context, client IClient) context.Context {
	return context.WithValue(ctx, clientKeyCtx{}, client)
}

func ExtractClient(ctx context.Context) IClient {
	if val := ctx.Value(clientKeyCtx{}); val != nil {
		if client, ok := val.(IClient); ok {
			return client
		}
	}
	return nil
}
