package events

import (
	"agent/commons/utils"
	"agent/commons/vars"
	"agent/defines/dhandlers"
)

func NewRequest(opts ...*EventRequestOpts) *EventRequest {
	res := EventRequest{
		//Handler: dhandlers.Json,
		Handler: dhandlers.BinaryJson,
		//Handler: dhandlers.OctetStream,

		// На данные момент не поддерживается в связи с новым протоколом взаимодействия с сервисом.
		//Handler: dhandlers.FormData,
	}
	if len(opts) > 0 && opts[0] != nil {
		o := opts[0]
		if o.Parallel {
			res.Parallel = o.Parallel
		}
		if o.Handler != 0 {
			res.Handler = o.Handler
		}
		if o.Binary != nil {
			res.Binary = o.Binary
		}
		if o.Headers != nil {
			res.Headers = o.Headers
		}
		if o.Cookies != nil {
			res.Cookies = o.Cookies
		}
		if o.MinTrashSize != nil && *o.MinTrashSize > -1 {
			res.MinTrashSize = o.MinTrashSize
		}
		if o.MaxTrashSize != nil && *o.MaxTrashSize > -1 {
			res.MaxTrashSize = o.MaxTrashSize
		}

		res.FormData = o.FormData
	}

	if res.Handler == dhandlers.FormData {
		formOpts := &res.FormData.Event
		if len(formOpts.Field) == 0 {
			formOpts.Field = utils.RandomString(vars.DefaultAlphabet, utils.IntN(12)+4)
		}
		if len(formOpts.Filename) == 0 {
			formOpts.Filename = formOpts.Field + vars.DefaultFormDataFileExtension
		}
	}

	return &res
}

func NewResponse(opts ...*EventResponseOpts) *EventResponse {
	res := EventResponse{
		Exist:  true,
		Base64: true,
		// Не пытайтесь ставить false, клиент будет считать данные не зашифрованными, но сервер автоматически
		// перезаписывает это поле у себя в true и возвращает данные зашифрованными.
		Encrypt: true,
		// Значение по умолчанию равно -1, что означает, что будут использоваться настройки сервиса.
		MinTrashSize: -1,
		MaxTrashSize: -1,
	}
	if len(opts) > 0 && opts[0] != nil {
		o := opts[0]
		if len(o.Handler) > 0 {
			res.Handler = o.Handler
		}
		if len(o.Type) > 0 {
			res.Type = o.Type
		}
		if o.Encrypt != nil {
			res.Encrypt = *o.Encrypt
		}
		if o.Base64 != nil {
			res.Base64 = *o.Base64
		}
		if o.DataOnly != nil {
			res.DataOnly = *o.DataOnly
		}
		if o.Exist != nil {
			res.Exist = *o.Exist
		}

		if o.SendFile != nil {
			res.SendFile = *o.SendFile
		}
		if len(o.Filename) > 0 {
			res.Filename = o.Filename
		}
		if o.TypeFromFile != nil {
			res.TypeFromFile = *o.TypeFromFile
		}

		if o.MinTrashSize != nil && *o.MaxTrashSize > -1 {
			res.MinTrashSize = *o.MinTrashSize
		}
		if o.MaxTrashSize != nil && *o.MaxTrashSize > -1 {
			res.MaxTrashSize = *o.MaxTrashSize
		}

		if o.Exist != nil {
			res.Exist = *o.Exist
		}
		if o.CanEmpty != nil {
			res.CanEmpty = *o.CanEmpty
		}
		if len(o.ToFilePath) > 0 {
			res.ToFilePath = o.ToFilePath
		}
		if o.MaxDataSizeInMemory > 0 {
			res.MaxDataSizeInMemory = o.MaxDataSizeInMemory
		}
	}
	return &res
}
