package opts

import "agent/commons/adata"

type eventCleanupOptKey struct{}

func SetCleanup(event IEvent, flag bool) {
	event.SetOptValue(eventCleanupOptKey{}, true)
}

// SetCleanup определяет, будет ли ивент очищен, после своей обработки.
// - Если flag == true, ивент будет очищен.
// - Если flag == false, ивент останется в системе, после своей обработки.
// Примечание: сам client не занимается очисткой ивентов
func IsCleanup(event IEvent) bool {
	if val, ok := event.OptValue(eventCleanupOptKey{}); ok {
		return val.(bool)
	}
	return false
}

type eventRequestOptKey struct{}

func SetRequest(event IEvent, opts *EventRequest) {
	event.SetOptValue(eventRequestOptKey{}, opts)
}

func Request(event IEvent) *EventRequest {
	if val, ok := event.OptValue(eventRequestOptKey{}); ok {
		return val.(*EventRequest)
	}
	return nil
}

type eventResponseOptKey struct{}

func SetResponse(event IEvent, opts *EventResponse) {
	event.SetOptValue(eventResponseOptKey{}, opts)
}

func Response(event IEvent) *EventResponse {
	if val, ok := event.OptValue(eventResponseOptKey{}); ok {
		return val.(*EventResponse)
	}
	return nil
}

type eventDataOptKey struct{}

func SetData(event IEvent, data adata.IData) {
	event.SetOptValue(eventDataOptKey{}, data)
}

func Data(event IEvent) (data adata.IData) {
	if val, ok := event.OptValue(eventDataOptKey{}); ok {
		data, _ = val.(adata.IData)
	}
	if data == nil {
		data = adata.NewDataFromMem(nil)
	}
	return data
}

type eventErrorDataOptKey struct{}

func SetErrData(event IEvent, data string) {
	event.SetOptValue(eventErrorDataOptKey{}, data)
}

func ErrData(event IEvent) (data string, ok bool) {
	if val, ok := event.OptValue(eventErrorDataOptKey{}); ok {
		data, ok = val.(string)
		return data, ok
	}
	return "", false
}

type eventCreatedOptKey struct{}

func SetCreated(event IEvent, val int64) {
	event.SetOptValue(eventCreatedOptKey{}, val)
}

func Created(event IEvent) int64 {
	if val, ok := event.OptValue(eventCreatedOptKey{}); ok {
		return val.(int64)
	}
	return 0
}

type eventDestOptKey struct{}

func SetDest(event IEvent, dest any) {
	event.SetOptValue(eventDestOptKey{}, dest)
}

func Dest(event IEvent) any {
	if val, ok := event.OptValue(eventDestOptKey{}); ok {
		return val
	}
	return nil
}

type eventHoldOnErrorOptKey struct{}

func SetHoldOnError(event IEvent, flag bool) {
	event.SetOptValue(eventHoldOnErrorOptKey{}, flag)
}

func HoldOnError(event IEvent) bool {
	if val, ok := event.OptValue(eventHoldOnErrorOptKey{}); ok {
		return val.(bool)
	}
	return true
}
