//go:build debug

package config

import (
	"agent/commons/debug"
	"agent/commons/utils"
	"agent/defines/derrs"
	"agent/internal/include"
	"os"
	"path/filepath"
)

// Get возвращает конфиг из файла
func Get(configFile_ ...string) (config *include.AppConfig, err error) {
	if len(configFile_) == 0 {
		return nil, derrs.NewIncorrectParamsError("config file path is required")
	}

	configFile := configFile_[0]
	if configFile, err = filepath.Abs(configFile); err != nil {
		return nil, err
	}

	if !utils.FileIsExist(configFile) {
		debug.Logf(`Config file "%s" not found, using built-in config`, configFile)

		if config, err = DecryptData(Data, Key); err != nil {
			return nil, err
		}

	} else {
		debug.Logf(`Using config file: "%s"`, configFile)

		data, err := os.ReadFile(configFile)
		if err != nil {
			return nil, err
		}
		if config, err = FromBytes(data); err != nil {
			return nil, err
		}
	}

	return config, nil
}
