package cmds

import "context"

type commandManagerKeyCtx struct{}

func SetCommandManager(ctx context.Context, mananger *CommandManager) context.Context {
	return context.WithValue(ctx, commandManagerKeyCtx{}, mananger)
}

func ExtractCommandManager(ctx context.Context) *CommandManager {
	if val := ctx.Value(commandManagerKeyCtx{}); val != nil {
		if manager, ok := val.(*CommandManager); ok {
			return manager
		}
	}
	return nil
}
