package api

import (
	"agent/client/events"
	"context"
	"encoding/json"
)

type Right struct {
	Uuid        UUID   `json:"uuid"`
	Name        string `json:"name"`
	Description string `json:"description"`
	Tag         string `json:"tag"`
	Created     int64  `json:"created"`
	Updated     int64  `json:"updated"`
}

func RightGetByUuid(ctx context.Context, client IClient,
	uuid UUID,
) (res Right, err error) {
	event, err := EventRightGetByUuid(uuid)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func RightGetByTag(ctx context.Context, client IClient,
	tag string,
) (res Right, err error) {
	event, err := EventRightGetByTag(tag)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func RightUpdate(ctx context.Context, client IClient,
	args RightUpdateArgs,
) (res Right, err error) {
	event, err := EventRightUpdate(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func RightList(ctx context.Context, client IClient,
	args RightListArgs,
) (res []Right, err error) {
	event, err := EventRightList(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}
