package api

import (
	"agent/client/events"
	"agent/commons/utils"
	"agent/defines/devent/daction"
	"agent/defines/devent/dcategory"
	"agent/defines/devent/dkind"
)

type RightGetArgs struct {
	Uuid UUID   `json:"uuid,omitempty"`
	Tag  string `json:"tag,omitempty"`
}

func EventRightGet(args RightGetArgs) (IEvent, error) {
	meta, err := utils.ConvertTo[map[string]any](args)
	if err != nil {
		return nil, err
	}
	return events.NewEvent(
		dkind.UserToService,
		[]Category{dcategory.Service, dcategory.Right},
		daction.Get,
		meta,
	), nil
}

func EventRightGetByUuid(uuid UUID) (IEvent, error) {
	args := RightGetArgs{
		Uuid: uuid,
	}
	return EventRightGet(args)
}

func EventRightGetByTag(tag string) (IEvent, error) {
	args := RightGetArgs{
		Tag: tag,
	}
	return EventRightGet(args)
}

type RightUpdateArgs struct {
	Uuid UUID   `json:"uuid"`
	Name string `json:"name,omitempty"`
	Desc string `json:"desc,omitempty"`
}

func EventRightUpdate(args RightUpdateArgs) (IEvent, error) {
	meta, err := utils.ConvertTo[map[string]any](args)
	if err != nil {
		return nil, err
	}
	return events.NewEvent(
		dkind.UserToService,
		[]Category{dcategory.Service, dcategory.Right},
		daction.Update,
		meta,
	), nil
}

type RightListArgs struct {
	Offset int64 `json:"offset,omitempty"`
	Limit  int64 `json:"limit,omitempty"`
}

func EventRightList(args RightListArgs) (IEvent, error) {
	meta, err := utils.ConvertTo[map[string]any](args)
	if err != nil {
		return nil, err
	}
	return events.NewEvent(
		dkind.UserToService,
		[]Category{dcategory.Service, dcategory.Right},
		daction.List,
		meta,
	), nil
}
