//go:build debug || dev || sdk

package main

import (
	_ "agent/transports/http"
	_ "agent/transports/tcp"

	"agent/api"
	"agent/api/commons"
	"agent/client"
	"context"
	"fmt"

	"github.com/google/uuid"
)

func PrintAll(ctx context.Context, cl client.IClient, search ...string) error {
	args := api.UserGroupListAllArgs{}
	if len(search) > 0 {
		args.Search = search[0]
	}
	userGroups, err := api.UserGroupListAll(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, ug := range userGroups {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\" GroupName: \"%s\", GroupUuid: \"%s\"\n",
			ug.Name, ug.Uuid, ug.Name, ug.Uuid,
		)
	}
	return nil
}

func PrintByAgentUuid(ctx context.Context, cl client.IClient, agentUuid api.UUID, search ...string) error {
	args := api.UserGroupListByAgentArgs{
		AgentUuid: agentUuid,
	}
	if len(search) > 0 {
		args.Search = search[0]
	}
	userGroups, err := api.UserGroupListByAgent(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, ug := range userGroups {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\" GroupName: \"%s\", GroupUuid: \"%s\"\n",
			ug.Name, ug.Uuid, ug.Name, ug.Uuid,
		)
	}
	return nil
}

func main() {
	args := commons.UserClientArgs{
		Login:   "system",
		Passw:   "1234567890",
		LogFile: "app.log",
	}

	ctx, cl, err := commons.NewUserClient(args)
	if err != nil {
		panic(err)
	}

	if err = PrintAll(ctx, cl); err != nil {
		panic(err)
	}

	debugAgentUuid := uuid.MustParse("00000000-0000-0000-0000-000000011111")
	if err = PrintByAgentUuid(ctx, cl, debugAgentUuid); err != nil {
		panic(err)
	}
}
