//go:build debug || dev || sdk

package main

import (
	_ "agent/transports/http"
	_ "agent/transports/tcp"

	"agent/api"
	"agent/api/commons"
	"agent/client"
	"context"
	"fmt"

	"github.com/google/uuid"
)

func PrintAll(ctx context.Context, cl client.IClient, search ...string) error {
	projects, err := api.ProjectListAll(ctx, cl, search...)
	if err != nil {
		return err
	}
	for _, p := range projects {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\"\n",
			p.Name, p.Uuid,
		)
	}
	return nil
}

func PrintByAgentUuid(ctx context.Context, cl client.IClient, agentUuid api.UUID, search ...string) error {
	projects, err := api.ProjectListByAgent(ctx, cl, agentUuid, search...)
	if err != nil {
		return err
	}
	for _, p := range projects {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\"\n",
			p.Name, p.Uuid,
		)
	}
	return nil
}

func main() {
	args := commons.UserClientArgs{
		Login:   "system",
		Passw:   "1234567890",
		LogFile: "app.log",
	}

	ctx, cl, err := commons.NewUserClient(args)
	if err != nil {
		panic(err)
	}

	if err = PrintAll(ctx, cl); err != nil {
		panic(err)
	}

	debugAgentUuid := uuid.MustParse("00000000-0000-0000-0000-000000011111")
	if err = PrintByAgentUuid(ctx, cl, debugAgentUuid); err != nil {
		panic(err)
	}
}
