//go:build debug || dev || sdk

package main

import (
	_ "agent/transports/http"
	_ "agent/transports/tcp"

	"agent/api"
	"agent/api/commons"
	"agent/client"
	"agent/commons/utils"
	"context"
	"fmt"

	"github.com/google/uuid"
)

func PrintAll(ctx context.Context, cl client.IClient, search ...string) error {
	args := api.ClientHandshakeListAllArgs{
		Offset:  0,
		Limit:   100,
		Reverse: utils.PointerTo(false),
	}
	if len(search) > 0 {
		args.Search = search[0]
	}
	handshakes, err := api.ClientHandshakeListAll(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, hs := range handshakes {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\", Name: \"%s\", Value: \"%s\"\n",
			hs.ProjectName, hs.ProjectUuid, hs.Name, hs.Value,
		)
	}
	return nil
}

func PrintByProject(ctx context.Context, cl client.IClient, projectUuid api.UUID, search ...string) error {
	args := api.ClientHandshakeListByProjectArgs{
		ProjectUuid: projectUuid,
		Offset:      0,
		Limit:       100,
		Reverse:     utils.PointerTo(false),
	}
	if len(search) > 0 {
		args.Search = search[0]
	}
	handshakes, err := api.ClientHandshakeListByProject(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, hs := range handshakes {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\", Name: \"%s\", Value: \"%s\"\n",
			hs.ProjectName, hs.ProjectUuid, hs.Name, hs.Value,
		)
	}
	return nil
}

func main() {
	args := commons.UserClientArgs{
		Login:   "system",
		Passw:   "1234567890",
		LogFile: "app.log",
	}

	ctx, cl, err := commons.NewUserClient(args)
	if err != nil {
		panic(err)
	}

	if err = PrintAll(ctx, cl); err != nil {
		panic(err)
	}

	systemProjectUuid := uuid.MustParse("11111111-0001-0000-0000-000000000000")
	if err = PrintByProject(ctx, cl, systemProjectUuid); err != nil {
		panic(err)
	}
}
