//go:build debug || dev || sdk

package main

import (
	_ "agent/transports/http"
	_ "agent/transports/tcp"

	"agent/api"
	"agent/api/commons"
	"agent/client"
	"context"
	"fmt"

	"github.com/google/uuid"
)

func PrintAll(ctx context.Context, cl client.IClient, search ...string) error {
	args := api.AgentGroupListAllArgs{}
	if len(search) > 0 {
		args.Search = search[0]
	}
	agentGroups, err := api.AgentGroupListAll(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, ag := range agentGroups {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\" GroupName: \"%s\", GroupUuid: \"%s\"\n",
			ag.Name, ag.Uuid, ag.Name, ag.Uuid,
		)
	}
	return nil
}

func PrintByAgentUuid(ctx context.Context, cl client.IClient, agentUuid api.UUID, search ...string) error {
	args := api.AgentGroupListByAgentsArgs{
		AgentUuids: []api.UUID{agentUuid},
	}
	if len(search) > 0 {
		args.Search = search[0]
	}
	agentGroups, err := api.AgentGroupListByAgents(ctx, cl, args)
	if err != nil {
		return err
	}
	for _, ag := range agentGroups {
		fmt.Printf(
			"Project: \"%s\", ProjectUuid: \"%s\" GroupName: \"%s\", GroupUuid: \"%s\"\n",
			ag.Name, ag.Uuid, ag.Name, ag.Uuid,
		)
	}
	return nil
}

func main() {
	args := commons.UserClientArgs{
		Login:   "system",
		Passw:   "1234567890",
		LogFile: "app.log",
	}

	ctx, cl, err := commons.NewUserClient(args)
	if err != nil {
		panic(err)
	}

	if err = PrintAll(ctx, cl); err != nil {
		panic(err)
	}

	debugAgentUuid := uuid.MustParse("00000000-0000-0000-0000-000000011111")
	if err = PrintByAgentUuid(ctx, cl, debugAgentUuid); err != nil {
		panic(err)
	}
}
