//go:build debug || dev || sdk

package commons

import (
	"agent/client"
	"agent/commons/bytes"
	"encoding/base64"
)

func NewUserConfig(args UserClientArgs) *client.AppConfig {
	if len(args.ServerSchema) == 0 {
		args.ServerSchema = "http"
	}
	if len(args.ServerHost) == 0 {
		args.ServerHost = "localhost"
	}
	if args.ServerPort == 0 {
		args.ServerPort = 50101
	}
	if len(args.ClientKey) == 0 {
		args.ClientKey = "default_key"
	}
	if len(args.ClientSchema) == 0 {
		args.ClientSchema = "demo1"
	}
	if len(args.HandshakeValue) == 0 {
		args.HandshakeValue = "demo1/RVZneImaq7zN3u/w=="
	}
	if len(args.HandshakeData) == 0 {
		args.HandshakeData = "MIIBCgKCAQEAy/oT7pXfSnxehg+VhmoSWo9sc+HUUwOkavfs35J4soBwFGrjO3UNvVN+uDJZ0BodglIyQUNbWuBbm58GtKLW4EdezwM6BGz4j/oYQvnFA8+sgn9nz+Hlxhc3uckUP/UB4nJn6Lx+zCVJ44MfIicj7iju5z6oaZobCCoTxHfW+9XV915htORYJ6aEw67dOswc1eiJ6VTaV+EtfqzNFUUYuHE5IsgmwHG9Q8GDHv93KlFPk2iO0wEHi6V7bhGcwjIRzdxE/oALzTK8temPr1hcj48KVJCJgh9THYudEI4xBUuIR6cOOHNJSwGUDsi3gero2bvYv6g/s3xIqj2CV3I3NwIDAQAB"
	}

	srvCfg := client.ServerCfg{
		Schema: args.ServerSchema,
		Host:   args.ServerHost,
		Port:   args.ServerPort,
	}
	handshakeValue := args.HandshakeValue
	handshakeData := args.HandshakeData

	var err error
	if srvCfg.Handshake.Value, err = base64.StdEncoding.DecodeString(handshakeValue); err != nil {
		panic(err)
	}
	if srvCfg.Handshake.KeyData, err = base64.StdEncoding.DecodeString(handshakeData); err != nil {
		panic(err)
	}

	clientInterval := client.ClientItenterval{
		Ping:         0,
		Next:         0,
		Login:        0,
		ConsoleInput: 0,
	}

	clientCfg := client.ClientCfg{
		Name:            "api",
		Key:             args.ClientKey,
		Type:            "user",
		Version:         "api",
		Schema:          args.ClientSchema,
		CommandRound:    0,
		CommandPerRound: 0,
	}

	clientCfg.Cipher.Name = "Hb"
	clientCfg.Cipher.Key = bytes.Random(16)
	clientCfg.Interval = clientInterval

	scheduleCfg := client.ScheduleCfg{
		Version: 1,
	}
	scheduleCfg.Work.Days.Monday = true
	scheduleCfg.Work.Days.Tuesday = true
	scheduleCfg.Work.Days.Wednesday = true
	scheduleCfg.Work.Days.Thursday = true
	scheduleCfg.Work.Days.Friday = true
	scheduleCfg.Work.Days.Sunday = true
	scheduleCfg.Work.Days.Saturday = true
	scheduleCfg.Work.Time.Start.Hour = 0
	scheduleCfg.Work.Time.Start.Minute = 0
	scheduleCfg.Work.Time.End.Hour = 0
	scheduleCfg.Work.Time.End.Minute = 0

	return &client.AppConfig{
		Version:  1,
		Server:   srvCfg,
		Client:   clientCfg,
		Schedule: scheduleCfg,
	}
}
