package api

import (
	"agent/client/events"
	"agent/commons/utils"
	"agent/defines/devent/daction"
	"agent/defines/devent/dcategory"
	"agent/defines/devent/dkind"
)

func EventServiceCheckHealth(user ...bool) (IEvent, error) {
	kind := dkind.AgentToService
	if len(user) > 0 && user[0] {
		kind = dkind.UserToService
	}

	minTrashSize := int64(0)
	maxTrashSize := int64(1024)

	return events.NewEvent(
		events.EventKind(kind),
		[]events.EventCategory{dcategory.Service, dcategory.Health},
		daction.Check,
		nil,

		events.NewEventOpts{
			Request: &events.EventRequestOpts{
				Parallel:     true,
				MinTrashSize: &minTrashSize,
				MaxTrashSize: &maxTrashSize,
			},

			Response: &events.EventResponseOpts{
				Exist: utils.PointerTo(true),
			},
		},
	), nil
}
