package api

import (
	"agent/client/events"
	"context"
)

func ServiceCheckHealth(ctx context.Context, client IClient, user ...bool) error {
	jsonEvent, err := EventServiceCheckHealth(user...)
	if err != nil {
		return err
	}
	maskKey, err := events.ExecuteAndGetData(ctx, client, jsonEvent)
	if err != nil {
		return err
	}
	client.SetMaskKey(maskKey)
	return nil
}
