package api

import (
	"agent/client/events"
	"context"
	"encoding/json"
)

type AgentTag struct {
	AgentUuid UUID   `json:"agent_uuid"`
	Uuid      UUID   `json:"uuid"`
	Name      string `json:"name"`
	Color     string `json:"color"`
	Position  int    `json:"position"`
}

type AgentBaseTag struct {
	Uuid    UUID   `json:"uuid"`
	Name    string `json:"name"`
	Color   string `json:"color"`
	Created int64  `json:"created"`
	Updated int64  `json:"updated"`
}

func AgentBaseTagCreate(ctx context.Context, client IClient,
	args AgentBaseTagCreateArgs,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagCreate(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagGet(ctx context.Context, client IClient,
	args AgentBaseTagGetArgs,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagGet(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagGetByUuid(ctx context.Context, client IClient,
	uuid UUID,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagGetByUuid(uuid)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagGetByName(ctx context.Context, client IClient,
	name string,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagGetByName(name)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagDelete(ctx context.Context, client IClient,
	args AgentBaseTagDeleteArgs,
) error {
	event, err := EventAgentBaseTagDelete(args)
	if err != nil {
		return err
	}
	_, err = events.ExecuteAndGetData(ctx, client, event)
	return err
}

func AgentBaseTagList(ctx context.Context, client IClient,
	args AgentBaseTagListArggs,
) (res []AgentBaseTag, err error) {
	event, err := EventAgentBaseTagList(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagUpdate(ctx context.Context, client IClient,
	args AgentBaseTagUpdateArgs,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagUpdate(args)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagUpdateByUuid(ctx context.Context, client IClient,
	uuid UUID, name string, color string,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagUpdateByUuid(uuid, name, color)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentBaseTagUpdateByName(ctx context.Context, client IClient,
	oldName string, name string, color string,
) (res AgentBaseTag, err error) {
	event, err := EventAgentBaseTagUpdateByName(oldName, name, color)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagAdd(ctx context.Context, client IClient,
	args AgentTagAddArgs,
) (res []AgentTag, err error) {
	event, err := EventAgentTagAdd(args)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagDelete(ctx context.Context, client IClient,
	args AgentTagDeleteArgs,
) (res []AgentTag, err error) {
	event, err := EventAgentTagDelete(args)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagDeleteByUuid(ctx context.Context, client IClient,
	agentUuid UUID, tagUuid UUID,
) (res []AgentTag, err error) {
	event, err := EventAgentTagDeleteByUuid(agentUuid, tagUuid)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagDeleteByName(ctx context.Context, client IClient,
	agentUuid UUID, tagName string,
) (res []AgentTag, err error) {
	event, err := EventAgentTagDeleteByName(agentUuid, tagName)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagList(ctx context.Context, client IClient,
	agentUuid UUID,
) (res []AgentTag, err error) {
	event, err := EventAgentTagList(agentUuid)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentTagSet(ctx context.Context, client IClient,
	args AgentTagSetArgs,
) (res []AgentTag, err error) {
	event, err := EventAgentTagSet(args)
	if err != nil {
		return nil, err
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return nil, err
	}
	return res, json.Unmarshal(data, &res)
}
