package api

import (
	"agent/client/events"
	"agent/defines/devent/daction"
	"agent/defines/devent/dcategory"
	"agent/defines/devent/dkind"
)

type AgentSchedule struct {
	// Версия графика. Если она меньше чем на сервере, то будет использоваться график с сервера.
	Version int `json:"version"`

	// Рабочие дни и время работы агента. Если не указано, то агент работает круглосуточно.
	Work struct {
		// Дни недели, в которые работает агент. Если все значения равны false, то агент перестает работать. Но
		// независимо от настроект этого раздела, агент будет работать в дни, которые указанные в "makeup_days".
		Days struct {
			Monday    bool `json:"monday"`
			Tuesday   bool `json:"tuesday"`
			Wednesday bool `json:"wednesday"`
			Thursday  bool `json:"thursday"`
			Friday    bool `json:"friday"`
			Saturday  bool `json:"saturday"`
			Sunday    bool `json:"sunday"`
		} `json:"days"`
		// Время работы агента в рабочие дни. Если все значения равны 0, то агент работает круглосуточно.
		Time struct {
			// Начало рабочего дня. Формат: "HH:MM".
			Start struct {
				Hour   int `json:"hour"`
				Minute int `json:"minute"`
			} `json:"start"`
			// Конец рабочего дня. Формат: "HH:MM".
			End struct {
				Hour   int `json:"hour"`
				Minute int `json:"minute"`
			} `json:"end"`
		} `json:"time"`
	} `json:"work"`

	// Дни, когда агент должен работать вне графика. Если не указано, то агент работает по графику.
	MakeupDays map[string][]int `json:"makeup_days"`

	// Праздничные дни, когда агент не работает. Если не указано, то агент работает по графику.
	Hollidays map[string][]int `json:"holidays"`
}

func EventAgentScheduleSet(agentUuid UUID, schedule AgentSchedule) (IEvent, error) {
	meta := map[string]any{
		"agent_uuid": agentUuid,
		"schedule":   schedule,
	}
	return events.NewEvent(
		dkind.UserToService,
		[]Category{dcategory.Service, dcategory.Agent, dcategory.Schedule},
		daction.Set,
		meta,
	), nil
}

func EventAgentScheduleGet(agentUuid UUID) (IEvent, error) {
	meta := map[string]any{
		"agent_uuid": agentUuid,
	}
	return events.NewEvent(
		dkind.UserToService,
		[]Category{dcategory.Service, dcategory.Agent, dcategory.Schedule},
		daction.Get,
		meta,
	), nil
}
