package api

import (
	"agent/client/events"
	"context"
	"encoding/json"
)

func AgentScheduleSet(ctx context.Context, client IClient,
	agentUuid UUID, schedule AgentSchedule,
) (res AgentSchedule, err error) {
	event, err := EventAgentScheduleSet(agentUuid, schedule)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}

func AgentScheduleGet(ctx context.Context, client IClient,
	agentUuid UUID,
) (res AgentSchedule, err error) {
	event, err := EventAgentScheduleGet(agentUuid)
	if err != nil {
		return res, nil
	}
	data, err := events.ExecuteAndGetData(ctx, client, event)
	if err != nil {
		return res, err
	}
	return res, json.Unmarshal(data, &res)
}
